// selectSort.java
// demonstruje algorytm sortowania przez wybr
// uruchomienie programu: C>java SelectSortApp
////////////////////////////////////////////////////////////////
class ArraySel
   {
   private long[] a;                 // referencja do tablicy
   private int nElems;               // liczba elementw w tablicy
//--------------------------------------------------------------
   public ArraySel(int max)          // konstruktor
      {
      a = new long[max];                 // tworzymy tablic
      nElems = 0;                        // na razie brak elementw
      }
//--------------------------------------------------------------
   public void insert(long value)    // wstawienie element do tablicy
      {
      a[nElems] = value;             // wstawiamy element 
      nElems++;                      // zwikszenie licznika elementw
      }
//--------------------------------------------------------------
   public void display()             // wypisanie zawartoci tablicy
      {
      for(int j=0; j<nElems; j++)       // dla kadego elementu...
         System.out.print(a[j] + " ");  // ...wypisujemy jego warto
      System.out.println("");
      }
//--------------------------------------------------------------
   public void selectionSort()
      {
      int out, in, min;

      for(out=0; out<nElems-1; out++)   // ptla zewntrzna
         {
         min = out;                     // warto minimum
         for(in=out+1; in<nElems; in++) // ptla wewntrzna
            if(a[in] < a[min] )         // jeeli min wiksze...
                min = in;               // ...mamy nowe minimum
         swap(out, min);                // zamiana
         }  // koniec ptli zewntrznej
      }  // koniec selectionSort()
//--------------------------------------------------------------
   private void swap(int one, int two)
      {
      long temp = a[one];
      a[one] = a[two];
      a[two] = temp;
      }
//--------------------------------------------------------------
   }  // koniec klasy ArraySel
////////////////////////////////////////////////////////////////
class SelectSortApp
   {
   public static void main(String[] args)
      {
      int maxSize = 100;            // rozmiar tablicy
      ArraySel arr;                 // referencja do tablicy
      arr = new ArraySel(maxSize);  // tworzymy tablic

      arr.insert(77);               // wstawiamy 10 elementw
      arr.insert(99);
      arr.insert(44);
      arr.insert(55);
      arr.insert(22);
      arr.insert(88);
      arr.insert(11);
      arr.insert(00);
      arr.insert(66);
      arr.insert(33);

      arr.display();                // wypisujemy je

      arr.selectionSort();          // sortujemy przez wybr

      arr.display();                // i znw wypisujemy
      }  // koniec main()
   }  // koniec klasy SelectSortApp
////////////////////////////////////////////////////////////////
